# debug.bash - Debugging functions.

# (C) Copyright IBM Corp. 2003

# This file is part of the Linux lsvpd package.

# Maintained by Martin Schwenke <martins@au.ibm.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
# $Id: debug.bash,v 1.1 2006/04/11 18:38:28 emunson Exp $

# debug() - If debugging echo args to stderr.

# debug_cmd() - If not debugging run command discarding stderr,
# otherwise just run.

[ -n "$LSVPD_DEBUG" ] || LSVPD_DEBUG=false

if $LSVPD_DEBUG ; then
    function debug ()
    {
	echo "$@" 1>&2
    }
    function debug_cmd ()
    {
	"$@"
    }
else
    function debug ()
    {
	:
    }
    function debug_cmd ()
    {
	"$@" 2>/dev/null
    }
fi
